% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-methods.R, R/available.R
\name{import-methods}
\alias{import-methods}
\alias{import}
\alias{import,CoolFile-method}
\alias{import,HicFile-method}
\alias{import,HicproFile-method}
\alias{import,PairsFile-method}
\alias{import,CoolFile,ANY,ANY-method}
\alias{import,HicFile,ANY,ANY-method}
\alias{import,HicproFile,ANY,ANY-method}
\alias{import,PairsFile,ANY,ANY-method}
\alias{availableResolutions,ANY-method}
\alias{availableResolutions,CoolFile-method}
\alias{availableResolutions,HicFile-method}
\alias{availableResolutions,HicproFile-method}
\alias{availableChromosomes,ANY-method}
\alias{availableChromosomes,CoolFile-method}
\alias{availableChromosomes,HicFile-method}
\alias{availableChromosomes,HicproFile-method}
\title{HiCExperiment import methods}
\usage{
import(con, format, text, ...)

\S4method{availableResolutions}{ANY}(x, ...)

\S4method{availableResolutions}{CoolFile}(x)

\S4method{availableResolutions}{HicFile}(x)

\S4method{availableResolutions}{HicproFile}(x)

\S4method{availableChromosomes}{ANY}(x, ...)

\S4method{availableChromosomes}{CoolFile}(x)

\S4method{availableChromosomes}{HicFile}(x)

\S4method{availableChromosomes}{HicproFile}(x)
}
\arguments{
\item{...}{Extra parameters to pass to
format-specific methods. A list of possible arguments is
provided in the next section.}

\item{con, x}{Path or connection to a cool, mcool, .hic or HiC-Pro derived files.
Can also be a path to a pairs file.}

\item{format}{The format of the output. If missing and 'con' is a filename,
the format is derived from the file extension.
This argument is unnecessary when files are directly provided as
\code{CoolFile}, \code{HicFile}, \code{HicproFile} or \code{PairsFile}.}

\item{text}{If 'con' is missing, this can be a character vector directly
providing the string data to import.}
}
\value{
A \code{HiCExperiment} or \code{GInteractions} object
}
\description{
Import methods to parse Hi-C files (\verb{.(m)cool}, \code{.hic}, HiC-Pro derived
matrices, pairs files) into data structures implemented in the
HiCExperiment package.
}
\section{import arguments for ContactFile class}{

\code{ContactFile} class gathers \code{CoolFile}, \code{HicFile} and \code{HicproFile} classes.
When importing a \code{ContactFile} object in R, two main arguments can be
provided besides the \code{ContactFile} itself:
\itemize{
\item \code{resolution}:
Resolutions available in the disk-stored contact matrix can be
listed using \code{availableResolutions(file)}
\item \code{focus}:
A genomic locus (or pair of loci) provided as a string. It can be any
of the following string structures:
\itemize{
\item \code{"II"} or \code{"II:20001-30000"}: this will extract a symmetrical
square HiCExperiment object, of an entire chromosome or an portion of it.
\item \code{"II|III"} or \code{"II:20001-30000|III:40001-90000"}:
this will extract a non-symmetrical HiCExperiment object,
with an entire or portion of different chromosomes on each axis.
}
}
}

\examples{
################################################################
## ----------- Importing .(m)cool contact matrices ---------- ##
################################################################

mcoolPath <- HiContactsData::HiContactsData('yeast_wt', 'mcool')
availableResolutions(mcoolPath)
availableChromosomes(mcoolPath)
import(mcoolPath, resolution = 16000, focus = 'XVI', format = 'cool')

################################################################
## ------------ Importing .hic contact matrices ------------- ##
################################################################

hicPath <- HiContactsData::HiContactsData('yeast_wt', 'hic')
availableResolutions(hicPath)
availableChromosomes(hicPath)
import(hicPath, resolution = 16000, focus = 'XVI', format = 'hic')

################################################################
## ------- Importing HiC-Pro derived contact matrices ------- ##
################################################################

hicproMatrixPath <- HiContactsData::HiContactsData('yeast_wt', 'hicpro_matrix')
hicproBedPath <- HiContactsData::HiContactsData('yeast_wt', 'hicpro_bed')
availableResolutions(hicproMatrixPath, hicproBedPath)
availableChromosomes(hicproMatrixPath, hicproBedPath)
import(hicproMatrixPath, bed = hicproBedPath, format = 'hicpro')
}
