% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HiCDCPlus_chr.R
\name{HiCDCPlus_chr}
\alias{HiCDCPlus_chr}
\title{HiCDCPlus_chr}
\usage{
HiCDCPlus_chr(
  gi,
  covariates = NULL,
  distance_type = "spline",
  model_distribution = "nb",
  binned = TRUE,
  df = 6,
  Dmin = 0,
  Dmax = 2e+06,
  ssize = 0.01,
  splineknotting = "uniform",
  model_filepath = NULL
)
}
\arguments{
\item{gi}{Instance of a single chromosome \code{GenomicInteractions} object
containing intra-chromosomal interaction information
(minimally containing counts and genomic distance).}

\item{covariates}{covariates to be considered in addition to genomic
distance D. Defaults to all covariates besides 
'D','counts','mu','sdev',pvalue','qvalue' 
in \code{mcols(gi)}}

\item{distance_type}{distance covariate form: 'spline' or 'log'.
Defaults to 'spline'.}

\item{model_distribution}{'nb' uses a Negative Binomial model, 
'nb_vardisp' uses a Negative Binomial model with a distance specific 
dispersion parameter inferred from the data, 'nb_hurdle' uses the legacy
HiC-DC model.}

\item{binned}{TRUE if uniformly binned or FALSE if binned by
restriction enzyme fragment cut sites.}

\item{df}{degrees of freedom for the genomic distance spline
function if \code{distance_type='spline'}. Defaults to 6, which corresponds to
a cubic spline as explained in Carty et al. (2017)}

\item{Dmin}{minimum distance (included) to check for significant interactions,
defaults to 0}

\item{Dmax}{maximum distance (included) to check for significant interactions,
defaults to 2e6 or maximum in the data; whichever is minimum.}

\item{ssize}{Distance stratified sampling size. Can decrease for
large chromosomes. Increase recommended if
model fails to converge. Defaults to 0.01.}

\item{splineknotting}{Spline knotting strategy. Either "uniform", uniformly
spaced in distance, or placed based on distance distribution of counts 
"count-based" (i.e., more closely spaced where counts are more dense).}

\item{model_filepath}{Outputs fitted HiC-DC model object as an .rds
file with chromosome name indicatd on it. Defaults to NULL (no output).}
}
\value{
A valid \code{gi} instance with additional \code{mcols(.)}: 
pvalue': significance \emph{P}-value, 'qvalue': FDR 
corrected \emph{P}-value, mu': expected counts, 'sdev': modeled standard
deviation of expected counts.
}
\description{
This function finds significant interactions in a HiC-DC readable matrix
restricted to a single chromosome and expresses statistical significance of 
counts through the following:
'pvalue': significance \emph{P}-value, 'qvalue': FDR corrected 
\emph{P}-value, mu': expected counts, 'sdev': modeled standard deviation
of expected counts.
}
\examples{
gi_list<-generate_binned_gi_list(50e3,chrs='chr22')
gi_list<-add_hic_counts(gi_list,
hic_path<-system.file("extdata", "GSE63525_HMEC_combined_example.hic",
package = "HiCDCPlus"))
gi<-HiCDCPlus_chr(gi_list[[1]])
}
