% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrickContainer_functions.R
\name{BrickContainer_unlink_resolution}
\alias{BrickContainer_unlink_resolution}
\title{Remove links to all Hi-C matrices for a given resolution.}
\usage{
BrickContainer_unlink_resolution(Brick = NULL, resolution = NULL)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with CreateBrick.}

\item{resolution}{\strong{Required}
A string specifying the resolution to remove. This string must match the
resolution values listed by \code{BrickContainer_list_resolutions}}
}
\value{
An object of class BrickContainer where the resolution
and links to its associated files have been removed
}
\description{
\code{BrickContainer_unlink_resolution} removes links to all files associated
to a given resolution
}
\examples{
Bintable.path <- system.file("extdata",
"Bintable_100kb.bins", package = "HiCBricks")

out_dir <- file.path(tempdir(), "BrickContainer_unlink_res_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test", 
    experiment_name = "Vignette Test", resolution = 100000, 
    remove_existing = TRUE)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test", 
    experiment_name = "Vignette Test", resolution = 40000, 
    remove_existing = TRUE)

BrickContainer_unlink_resolution(Brick = My_BrickContainer, 
resolution = 40000)

}
