% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covmat.ts.R
\name{covmat.ts}
\alias{covmat.ts}
\alias{print.covmat.ts}
\title{Nonparametric Tests for the Row or Column Covariance Matrix}
\usage{
covmat.ts(datamat = datamat, N = N, voi = "rows", centered = FALSE)
}
\arguments{
\item{datamat}{numeric matrix containing the transposable data.}

\item{N}{positive integer number indicating the sample size, i.e., the
number of subjects.}

\item{voi}{character indicating if the test should be applied on the row or
column covariance matrix. Options include '\code{rows}' or '\code{columns}'.}

\item{centered}{logical indicating if the transposable data are centered.
Options include \code{TRUE} or \code{FALSE}.}
}
\value{
It returns a list with components:
\item{diagonality.ts}{a list
containing the test statistic and p-value of the
diagonality hypothesis test.}
\item{sphericity.ts}{a list
containing the test statistic and p-value of the
sphericity hypothesis test.}
\item{identity.ts}{a list containing the test statistic and p-value of the
identity hypothesis test.}
\item{N}{the sample size.}
\item{n.rows}{the number of row
variables.}
\item{n.cols}{the number of column variables.}
\item{variables}{character indicating if the tests were applied to the row
or column covariance matrix.}
\item{centered}{logical indicating if the
transposable data were centered.}
}
\description{
Testing the sphericity, identity and diagonality hypotheses for
the row or column covariance matrix.
}
\details{
It is assumed that there are \code{nrow(datamat)} row variables and
\code{ncol(datamat)}/\code{N} column variables in \code{datamat}. Further,
\code{datamat} should be written in such a way that every
\code{ncol(datamat)}/\code{N} consecutive columns belong to the same subject
and the order of the column variables in each block is preserved across
subjects.

The tests are nonparametric and thus robust to some departures from the
matrix-variate normal model.
}
\examples{
data(VEGFmouse)
## Hypothesis tests for the covariance matrix of the genes (rows).
genes_cov_test <- covmat.ts(datamat = VEGFmouse, N = 40)
genes_cov_test
## Hypothesis tests for the covariance matrix of the tissues (columns).
tissues_cov_test <- covmat.ts(datamat = VEGFmouse, N = 40, voi = 'columns')
tissues_cov_test
}
\references{
Touloumis, A., Marioni, J.C. and Tavare, S. (2021) Hypothesis
Testing for the Covariance Matrix in High-Dimensional Transposable Data with
Kronecker Product Dependence Structure. \emph{Statistica Sinica} \bold{31},
1309--1329.
}
\author{
Anestis Touloumis
}
