\name{ComputeM}
\alias{ComputeM}
\title{Compute score matrix M}
\description{
  Compute the score matrix M.
}
\usage{
ComputeM(A, B, R, P, linkScore, selfLinkScore, nodeScore1,
  nodeScore0, lookupLink, lookupNode, clamp=TRUE)
}
\arguments{
  \item{A}{adjacency matrix for network A}
  \item{B}{adjacency matrix for network B}
  \item{R}{node similarity matrix}
  \item{P}{permutation vector to be used as the initial alignment (see \link{InitialAlignment})}
  \item{linkScore}{link score matrix (see \link{ComputeLinkParameters})}
  \item{selfLinkScore}{self link score matrix (see \link{ComputeLinkParameters})}
  \item{nodeScore1}{node score vector (s1) (see \link{ComputeNodeParameters})}
  \item{nodeScore0}{node score vector for unaligned nodes (s0) (see \link{ComputeNodeParameters})}
  \item{lookupLink}{link bin lookup table (see \link{GetBinNumber})}
  \item{lookupNode}{node bin lookup table (see \link{GetBinNumber})}
  \item{clamp}{clamp values to range when performing bin lookups}
}
\value{
  The return value is the score matrix M.
}
\details{
  This function computes the score Matrix M from the network adjacency 
  matrices A and B, the node similarity matrix R, an alignment P (given as a 
  permutation vector) and the node and link scores with their associated 
  binning information. The alignment P is either generated by the previous 
  iterative step, or, initially, by using \link{InitialAlignment}. The matrix M 
  is then given to the linear assignment solver to compute the new alignment.
}
\examples{
  ex<-GenerateExample(dimA=22, dimB=22, filling=.5, covariance=.6,
    symmetric=TRUE, numOrths=10, correlated=seq(1,18))
  
  pinitial<-InitialAlignment(psize=34, r=ex$r, mode="reciprocal")
  
  lookupLink<-seq(-2,2,.5)
  linkParams<-ComputeLinkParameters(ex$a, ex$b, pinitial, lookupLink)
  
  lookupNode<-c(-.5,.5,1.5)
  nodeParams<-ComputeNodeParameters(dimA=22, dimB=22, ex$r,
    pinitial, lookupNode)
  
  ComputeM(A=ex$a, B=ex$b, R=ex$r, P=pinitial,
    linkScore=linkParams$ls,
    selfLinkScore=linkParams$ls,
    nodeScore1=nodeParams$s1, nodeScore0=nodeParams$s0,
    lookupLink=lookupLink, lookupNode=lookupNode)
}
\author{Joern P. Meier, Michal Kolar, Ville Mustonen, Michael Laessig, and Johannes Berg}
\keyword{misc}
