% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxImportThermoDB.R
\name{gtoxImportThermoDB}
\alias{gtoxImportThermoDB}
\title{Import data from ThermoDB by study ID}
\usage{
gtoxImportThermoDB(asid, verbose = TRUE, write = FALSE,
  store = "STORE", type = "mc",
  curlurl = "https://YOUR_THERMODB_SERVER_HOSTNAME/HTTPHCSConnect")
}
\arguments{
\item{asid}{Integer, the assay study/source ID to import data for}

\item{verbose}{Logical, should the output from the curl be displayed?}

\item{write}{Logical, should the data be written to the database, or just
returned?}

\item{store}{Character, the name of the store on ThermoDB to query}

\item{type}{Character, the data type: 'mc' or 'sc'}

\item{curlurl}{URL of the webservice}
}
\value{
Data table with content fetched from Thermo DB.
}
\description{
This function accesses the ThermoDB webservices and imports
data from ThermoDB to the gtox database.
}
\examples{
## Fetches data from ThermoDB to load in GladiaTOX DB prior processing
conf_store <- gtoxConfList()
gtoxConfDefault()

\dontrun{
## Fetch data from ThermoDB
dat <- gtoxImportThermoDB(asid=1L)
}

## Reset configuration
options(conf_store)

}
