% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glPlotStat.R
\name{glPlotStat}
\alias{glPlotStat}
\title{Box plot for Minimal Effective Concentrations (MEC) and AC50 plot}
\usage{
glPlotStat(asid, ref.chm = NULL, stat = quote(modl_acc))
}
\arguments{
\item{asid}{Assay source id}

\item{ref.chm}{Chemical to adopt as reference}

\item{stat}{Character vector of statistic to export}
}
\value{
A list of ggplot objects, one per assay X timepoint.
}
\description{
This function plots MEC values
}
\details{
This function is useful to show the MEC trend over control chemical
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## Create boxplot of MEC
## plots in a pdf file.
pp <- glPlotStat(asid = 1L)
pp[[1]]

## Reset configuration
options(conf_store)

}
