% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-qc.R
\name{setSeqQCFlags}
\alias{setSeqQCFlags}
\title{Add sequencing QC flags to NanoStringGeoMxSet object protocol data}
\usage{
setSeqQCFlags(object, qcCutoffs = DEFAULTS)
}
\arguments{
\item{object}{name of the NanoStringGeoMxSet object to perform QC on}

\item{qcCutoffs}{a list of qc cutoffs to use
\enumerate{
    \item{minSegmentReads, 
          numeric to flag segments with less than this number of reads}
    \item{percentAligned, 
          numeric to flag segments with less than this percent of aligned reads}
    \item{percentSaturation, 
          numeric to flag segments with less than this percent of 
          sequencing saturation}
}}
}
\value{
\code{NanoStringGeoMxSet} object with \code{QCFlags} data frame 
            appended to \code{protocolData}
}
\description{
Add sequencing QC flags to NanoStringGeoMxSet object protocol data
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
                       package="GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
setSeqQCFlags(demoData[,1:10], 
                 qcCutoffs=list(minSegmentReads=1000, 
                                percentAligned=80, 
                                percentSaturation=50))

}
