% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-qc.R
\name{setBioProbeQCFlags}
\alias{setBioProbeQCFlags}
\title{Add probe QC flags to NanoStringGeoMxSet object feature data}
\usage{
setBioProbeQCFlags(object, qcCutoffs = DEFAULTS, removeLocalOutliers = TRUE)
}
\arguments{
\item{object}{name of the NanoStringGeoMxSet object to perform QC on}

\item{qcCutoffs}{a list of qc cutoffs to use
\enumerate{
    \item{minProbeRatio, 
          numeric between 0 and 1 to flag probes that have 
          (geomean probe in all segments) / (geomean probes within target)
          less than or equal to this ratio}
    \item{percentFailGrubbs, 
          numeric to flag probes that fail Grubb's test in 
          greater than or equal this percent of segments}
}}

\item{removeLocalOutliers}{boolean to determine if 
local outliers should be excluded from \code{exprs} matrix}
}
\value{
\code{NanoStringGeoMxSet} object with \code{QCFlags} data frame 
        appended to \code{protocolData}
}
\description{
Add probe QC flags to NanoStringGeoMxSet object feature data
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
                       package="GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
demoData <- shiftCountsOne(demoData, elt="exprs", useDALogic=TRUE)
setBioProbeQCFlags(demoData[,1:10], 
                   qcCutoffs=list(minProbeRatio=0.1,
                                  percentFailGrubbs=20),
                   removeLocalOutliers=TRUE)

}
