% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-autoplot.R
\name{qcProteinSignalNames}
\alias{qcProteinSignalNames}
\title{Generate list of proteins ordered by SNR}
\usage{
qcProteinSignalNames(object, neg.names)
}
\arguments{
\item{object}{name of the object class to subset
\enumerate{
    \item{NanoStringGeoMxSet, use the NanoStringGeoMxSet class}
}}

\item{neg.names}{names of IgGs, if NULL IgGs will be detected automatically}
}
\value{
protein names in increasing SNR order
}
\description{
For use with protein data ONLY.
}
\examples{
proteinData <- readRDS(file= system.file("extdata","DSP_Proteogenomics_Example_Data", 
"proteinData.rds", package = "GeomxTools"))

igg.names <- iggNames(proteinData)

proteinOrder <- qcProteinSignalNames(object = proteinData, neg.names = igg.names)

}
