% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-normalize.R
\name{normalize,NanoStringGeoMxSet-method}
\alias{normalize,NanoStringGeoMxSet-method}
\title{normalize}
\usage{
\S4method{normalize}{NanoStringGeoMxSet}(
  object,
  norm_method = c("quant", "neg", "hk", "subtractBackground"),
  fromElt = "exprs",
  toElt = "exprs_norm",
  housekeepers = HOUSEKEEPERS,
  ...
)
}
\arguments{
\item{object}{name of the object class to perform normalization on}

\item{norm_method}{the normalization method to be applied on the object}

\item{fromElt}{name of the assayDataElement to normalize}

\item{toElt}{name of the assayDataElement to store normalized values}

\item{housekeepers}{optional vector of housekeeper target names}

\item{...}{optional arguments}
}
\value{
a NanoStringGeoMxSet object with normalized counts and normalized factors
}
\description{
normalize GeoMxSet using different normalization methods
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
  package = "GeomxTools"
)
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
norm_object <- normalize(demoData[1:1000,1:10])
}
