% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-de.R
\name{mixedModelDE}
\alias{mixedModelDE}
\title{Run a mixed model on GeoMxSet}
\usage{
mixedModelDE(
  object,
  elt = "exprs",
  modelFormula = NULL,
  groupVar = "group",
  nCores = 1,
  multiCore = TRUE,
  pAdjust = "BY",
  pairwise = TRUE
)
}
\arguments{
\item{object}{name of the object class to perform QC on
\enumerate{
    \item{NanoStringGeoMxSet, use the NanoStringGeoMxSet class}
}}

\item{elt}{assayDataElement of the geoMxSet object to run the DE on}

\item{modelFormula}{formula used in DE, if null, the design(object) is used}

\item{groupVar}{= "group",  sample annotation to group the data for comparing means}

\item{nCores}{= 1, number of cores to use, set to 1 if running in serial mode}

\item{multiCore}{= TRUE, set to TRUE to use multiCore, FALSE to run in cluster mode}

\item{pAdjust}{= "BY" method for p-value adjustment}

\item{pairwise}{boolean to calculate least-square means pairwise differences}
}
\value{
mixed model output list
}
\description{
Run a mixed model on GeoMxSet
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data", package = "GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
target_demoData <- aggregateCounts(demoData)
target_demoData <- normalize(target_demoData, norm_method="quant")
pData(target_demoData)[["slide"]] <-
    factor(pData(target_demoData)[["slide name"]])
protocolData(target_demoData)[["pool_rep"]] <-
    factor(protocolData(target_demoData)[["pool_rep"]])
mixedOutmc <- mixedModelDE(target_demoData,
                           elt = "exprs_norm",
                           modelFormula = ~ pool_rep +  (1 | slide),
                           groupVar = "pool_rep",
                           nCores = 2,
                           multiCore = TRUE,
                           pAdjust = NULL
)

}
