% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBth.R
\docType{methods}
\name{fitNBth}
\alias{fitNBth}
\alias{fitNBth,NanoStringGeoMxSet-method}
\alias{fitNBth,matrix-method}
\title{Negative Binomial threshold model}
\usage{
fitNBth(object, ...)

\S4method{fitNBth}{NanoStringGeoMxSet}(
  object,
  split = TRUE,
  features_high = NULL,
  sizefact_BG = NULL,
  sizefact_start = sizefact_BG,
  size_scale = c("sum", "first"),
  threshold_start = NULL,
  threshold_fix = FALSE,
  tol = 1e-07,
  iterations = 8,
  start_para = c(threshold_start, 0.5),
  lower_sizefact = 0,
  lower_threshold = threshold_start/5
)

\S4method{fitNBth}{matrix}(
  object,
  features_high,
  probenum,
  sizefact_BG,
  sizefact_start = sizefact_BG,
  size_scale = c("sum", "first"),
  threshold_start,
  threshold_fix = FALSE,
  tol = 1e-07,
  iterations = 8,
  start_para = c(threshold_start, 1),
  lower_sizefact = 0,
  lower_threshold = threshold_start/5
)
}
\arguments{
\item{object}{count matrix with features in rows and samples in columns}

\item{...}{additional argument list that might be used}

\item{split}{indicator variable on whether it is for multiple slides (Yes, TRUE; No, FALSE)}

\item{features_high}{subset of features which are well above the background}

\item{sizefact_BG}{size factors for the background}

\item{sizefact_start}{initial value for size factors}

\item{size_scale}{method to scale the sizefact, sum(sizefact)=1 when size_scale="sum", sizefact[1]=1 when size_scale="first"}

\item{threshold_start}{initial value for threshold}

\item{threshold_fix}{whether to fix the threshold, default=FALSE}

\item{tol}{tolerance to determine convergence, default=1e-3}

\item{iterations}{maximum iterations to be run, default=5}

\item{start_para}{starting values for parameter estimation, default=c(threshold_start, 1)}

\item{lower_sizefact}{lower limit for sizefact, default=0}

\item{lower_threshold}{lower limit for threshold}

\item{probenum}{a vector of numbers of probes in each gene}
}
\value{
a valid GeoMx S4 object
\itemize{
  \item para0 = "NA", in experimentData
  \item para, estimated parameters, "signal" "r" in rows and features in columns, in featureData
  \item sizefact, estimated size factor, in phenoData
  \item preci1 = "NA", in experimentData
  \item conv0 = "NA", in experimentData
  \item conv = "NA", in experimentData
  \item Im = "NA", in experimentData
  \item features_high, a vector of indicators, in featureData (0: No; 1: Yes; NA: not included in features_high)
  \item features_all = "NA", in experimentData
  \item threshold, estimated threshold, when threshold_fix, equals to threshold_start, in experimentData
}

a list of following items, some items are place holders = NA
\itemize{
  \item para0 = NA,
  \item para, estimated parameters, "signal" "r" in rows and features in columns
  \item sizefact, estimated size factor
  \item preci1 = NA
  \item conv0 = NA
  \item conv = NA
  \item Im = NA
  \item features_high = features_high
  \item features_all = NA
  \item threshold, estimated threshold, when threshold_fix, equals to threshold_start
}
}
\description{
Estimate the signal size factor for features above the background

Estimate the signal size factor for features above the background
}
\examples{

library(Biobase)
library(dplyr)
data(demoData)
demoData <- fitPoisBG(demoData, size_scale = "sum")
demoData <- aggreprobe(demoData, use = "cor")
demoData <- BGScoreTest(demoData)
thmean <- 1 * mean(fData(demoData)$featfact, na.rm = TRUE)
demo_pos <- demoData[which(!fData(demoData)$CodeClass == "Negative"), ]
demo_neg <- demoData[which(fData(demoData)$CodeClass == "Negative"), ]
sc1_scores <- fData(demo_pos)[, "scores"]
names(sc1_scores) <- fData(demo_pos)[, "TargetName"]
features_high <- ((sc1_scores > quantile(sc1_scores, probs = 0.4)) &
   (sc1_scores < quantile(sc1_scores, probs = 0.95))) |>
    which() |>
    names()
set.seed(123)
features_high <- sample(features_high, 100)
demoData <- fitNBth(demoData,
                    features_high = features_high,
                    sizefact_BG = demo_neg$sizefact,
                    threshold_start = thmean,
                    iterations = 5,
                    start_para = c(200, 1),
                    lower_sizefact = 0,
                    lower_threshold = 100,
                    tol = 1e-8)

}
