% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBthDE.R
\docType{methods}
\name{coefNBth}
\alias{coefNBth}
\alias{coefNBth,list-method}
\title{Generate list of Wald test inference results on model coefficients}
\usage{
coefNBth(object, ...)

\S4method{coefNBth}{list}(object, fullpara = FALSE)
}
\arguments{
\item{object}{DE model, output by fitNBthDE or fitNBthmDE}

\item{...}{additional argument list that might be used}

\item{fullpara}{whether to generate results on all parameters}
}
\value{
\itemize{
  \item estimate, coefficients estimate
  \item wald_stat, Wald test statistics
  \item p_value, p value of Wald test
  \item se, standard error
}
}
\description{
Generate list of Wald test inference results including parameter estimation and p value
}
\examples{
data(NBthmDEmod2)
coeff <- coefNBth(NBthmDEmod2)
}
