% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawingFunctions.R
\name{draw_stacked_profile}
\alias{draw_stacked_profile}
\title{Plot signal profile around start, center, and end of genomic regions}
\usage{
draw_stacked_profile(
  plot_df,
  xc = "Position",
  yc = "Intensity",
  cn = "Query",
  ext = c(0, 0, 0, 0),
  hl = c(0, 0, 0, 0),
  atitle = "title",
  insert = 0,
  Ylab = "Signal Intensity",
  shade = FALSE,
  stack = TRUE
)
}
\arguments{
\item{plot_df}{a dataframe with column names c(xc, yc, cn, "Interval",
"lower", "upper")}

\item{xc}{a string denoting column name for values on x-axis}

\item{yc}{a string denoting column name for numeric data to be plotted}

\item{cn}{a string denoting column name for grouping}

\item{ext}{a vector of 4 integers denoting upstream and downstream extension
around start and end, the range of extensions must be within the range of
`xc` of the `plot_df`}

\item{hl}{a vector of 4 integers defining upstream and downstream boundaries
of the rectangle for start and end}

\item{atitle}{a string for the title of the plot}

\item{insert}{a integer denoting the width of the center region}

\item{Ylab}{a string for y-axis label}

\item{shade}{logical, indicating whether to place a shaded rectangle around
the point of interest}

\item{stack}{logical, indicating whether to plot the number of valid
(non-zero) data points in each bin}
}
\value{
a ggplot object
}
\description{
Plot lines with standard error as the error band, also plots
number of regions having non-zero signals
}
\note{
used by \code{\link{plot_start_end}},
 \code{\link{plot_start_end_with_random}}
}
\examples{
library(dplyr)
Reference <- rep(rep(c("Ref1", "Ref2"), each = 100), 2)
Query <- rep(c("Query1", "Query2"), each = 200)
Position <- rep(seq(-50, 49), 4)
Intensity <- rlnorm(400)
se <- runif(400)
start_df <- data.frame(Intensity, se, Position, Query, Reference) \%>\%
    mutate(lower = Intensity - se, upper = Intensity + se) \%>\%
    mutate(Group = paste(Query, Reference, sep = ":")) \%>\%
    mutate(Location = rep("Start", 400)) \%>\%
    mutate(Interval = sample.int(1000, 400))
Intensity <- rlnorm(400, meanlog = 1.5)
se <- runif(400)
center_df <- data.frame(Intensity, se, Position, Query, Reference) \%>\%
    mutate(lower = Intensity - se, upper = Intensity + se) \%>\%
    mutate(Group = paste(Query, Reference, sep = ":")) \%>\%
    mutate(Location = rep("Center", 400)) \%>\%
    mutate(Interval = sample.int(600, 400))
Intensity <- rlnorm(400, meanlog = 2)
se <- runif(400)
end_df <- data.frame(Intensity, se, Position, Query, Reference) \%>\%
    mutate(lower = Intensity - se, upper = Intensity + se) \%>\%
    mutate(Group = paste(Query, Reference, sep = ":")) \%>\%
    mutate(Location = rep("End", 400)) \%>\%
    mutate(Interval = sample.int(2000, 400))

df <- rbind(start_df, center_df, end_df)
p <- draw_stacked_profile(df, cn = "Group", shade = TRUE,
    ext = c(-50, 50, -50, 50),
    hl = c(-20, 20, -25, 25), insert = 100)
p


}
\author{
Shuye Pu
}
