% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawingFunctions.R
\name{draw_region_name}
\alias{draw_region_name}
\title{Plot genomic region names}
\usage{
draw_region_name(featureNames, scaled_bins, xmax)
}
\arguments{
\item{featureNames}{a string vector giving names of sub-regions}

\item{scaled_bins}{a vector of integers denoting the lengths of each
sub-region}

\item{xmax}{an integer denoting the right most boundary}
}
\value{
a ggplot object
}
\description{
Plot sub-region labels under the landmark
}
\note{
used by \code{\link{plot_5parts_metagene}}, \code{\link{plot_region}}
}
\examples{
fn <- c("5'UTR", "CDS", "3'UTR")
bins <- c(5, 15, 5)
xmax <- 25

p <- draw_region_name(featureNames = fn, scaled_bins = bins, xmax = xmax)

}
\author{
Shuye Pu
}
