% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HandleDataMatrix.R
\name{aov_TukeyHSD}
\alias{aov_TukeyHSD}
\title{Perform one-way ANOVA and post hoc TukeyHSD tests}
\usage{
aov_TukeyHSD(df, xc = "Group", yc = "Intensity", op = NULL, verbose = FALSE)
}
\arguments{
\item{df}{a dataframe}

\item{xc}{a string denoting column name for grouping}

\item{yc}{a string denoting column name for numeric data to be plotted}

\item{op}{output prefix for statistical analysis results}

\item{verbose}{logical, to indicate whether a file should be produced to
save the test results}
}
\value{
a list of two elements, the first is the p-value of ANOVA test and
the second is a matrix of the output of TukeyHSD tests
}
\description{
This is a helper function for performing one-way ANOVA analysis
and post hoc Tukey's Honest Significant Differences tests
}
\note{
used in \code{plot_locus}
}
\examples{
stat_df <- data.frame(
    Feature = rep(c("A", "B"), c(20, 30)),
    Intensity = c(rnorm(20, mean = 2, sd = 1), rnorm(30, mean = 3, sd = 1))
)

out <- aov_TukeyHSD(stat_df, xc = "Feature")
out

}
\author{
Shuye Pu
}
