% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content-plots.R
\name{plotGCContent}
\alias{plotGCContent}
\title{Plots a density distribution of GC vectors
Give results from the \code{calcGCContent} function, this will produce a
density plot}
\usage{
plotGCContent(gcvectors)
}
\arguments{
\item{gcvectors}{A numeric vector or list of numeric vectors of GC contents.}
}
\value{
A ggplot object plotting distribution of GC content in query regions.
}
\description{
Plots a density distribution of GC vectors
Give results from the \code{calcGCContent} function, this will produce a
density plot
}
\examples{
numVector = rnorm(400, mean=0.5, sd=0.1)
GCplot = plotGCContent(numVector)
vecs = list(example1 = rnorm(400, mean=0.5, sd=0.1), 
            example2 = rnorm(600, mean=0.5, sd=0.1))
GCplot = plotGCContent(vecs)

}
