% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrom-plots.R
\name{getGenomeBins}
\alias{getGenomeBins}
\title{Returns bins used in `calcChromBins` function
Given a named vector of chromosome sizes, the function returns
GRangesList object with bins for each chromosome.}
\usage{
getGenomeBins(chromSizes, binCount = 10000)
}
\arguments{
\item{chromSizes}{a named list of size (length) for each chromosome.}

\item{binCount}{number of bins (total; *not* per chromosome), 
defaults to 10,000}
}
\value{
A GRangesList object with bins that separate chromosomes
        into equal parts.
}
\description{
Returns bins used in `calcChromBins` function
Given a named vector of chromosome sizes, the function returns
GRangesList object with bins for each chromosome.
}
\examples{
chromSizes = getChromSizes("hg19")
chromBins  = getGenomeBins(chromSizes)

}
