% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature-plots.R
\name{calcFeatureDistRefTSS}
\alias{calcFeatureDistRefTSS}
\title{Calculates the distribution of distances from a query set to closest TSS}
\usage{
calcFeatureDistRefTSS(query, refAssembly)
}
\arguments{
\item{query}{A GenomicRanges or GenomicRangesList object with query regions}

\item{refAssembly}{A character vector specifying the reference genome
assembly (*e.g.* 'hg19'). This will be used to grab chromosome sizes with
\code{getTSSs}.}
}
\value{
A vector of distances for each query region relative to TSSs.
}
\description{
Given a query GRanges object and an assembly string, this function will grab
the TSS list for the given reference assembly and then calculate the distance
from each query feature to the closest TSS. It is a wrapper of
\code{calcFeatureDist} that uses built-in TSS features for a reference
assembly
}
\examples{
calcFeatureDistRefTSS(vistaEnhancers, "hg19")
}
