% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{response}
\alias{response}
\alias{GDCResponse}
\alias{response.GDCQuery}
\alias{response_all}
\title{Fetch \code{\link{GDCQuery}} metadata from GDC}
\usage{
response(x, ...)

\method{response}{GDCQuery}(x, from = 0, size = 10, ..., response_handler = jsonlite::fromJSON)

response_all(x, ...)
}
\arguments{
\item{x}{a \code{\link{GDCQuery}} object}

\item{...}{passed to httr (good for passing config info, etc.)}

\item{from}{integer index from which to start returning data}

\item{size}{number of records to return}

\item{response_handler}{a function that processes JSON (as text)
and returns an R object.  Default is \code{\link[jsonlite]{fromJSON}}.}
}
\value{
A \code{GDCResponse} object which is a list with the following
members:
\itemize{
\item{results}
\item{query}
\item{aggregations}
\item{pages}
}
}
\description{
Fetch \code{\link{GDCQuery}} metadata from GDC
}
\examples{

# basic class stuff
gCases = cases()
resp = response(gCases)
class(resp)
names(resp)

# And results from query
resp$results[[1]]

}
