% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifest.R
\name{manifest}
\alias{manifest}
\alias{manifest.gdc_files}
\alias{manifest.GDCfilesResponse}
\alias{manifest.GDCcasesResponse}
\title{Prepare GDC manifest file for bulk download}
\usage{
manifest(x, from = 0, size = count(x), ...)

\method{manifest}{gdc_files}(x, from = 0, size = count(x), ...)

\method{manifest}{GDCfilesResponse}(x, from = 0, size = count(x), ...)

\method{manifest}{GDCcasesResponse}(x, from = 0, size = count(x), ...)
}
\arguments{
\item{x}{An \code{\link{GDCQuery}} object of subclass "gdc_files" or "gdc_cases".}

\item{from}{Record number from which to start when returning the manifest.}

\item{size}{The total number of records to return.  Default 
will return the usually desirable full set of records.}

\item{...}{passed to \code{\link[httr]{PUT}}.}
}
\value{
A \code{\link[tibble]{tibble}}, also of type "gdc_manifest", with five columns:
\itemize{
\item{id}
\item{filename}
\item{md5}
\item{size}
\item{state}
}
}
\description{
The \code{manifest} function/method creates a manifest of files to be downloaded
using the GDC Data Transfer Tool. There are methods for
creating manifest data frames from \code{\link{GDCQuery}} objects
that contain file information ("cases" and "files" queries).
}
\section{Methods (by class)}{
\itemize{
\item \code{manifest(gdc_files)}: 

\item \code{manifest(GDCfilesResponse)}: 

\item \code{manifest(GDCcasesResponse)}: 

}}
\examples{
gFiles = files()
shortManifest = gFiles |> manifest(size=10)
head(shortManifest,n=3)


}
