% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields.R
\name{field_description}
\alias{field_description}
\alias{field_description.GDCQuery}
\alias{field_description.character}
\title{S3 Generic that returns the field description text, if available}
\usage{
field_description(entity, field)

\method{field_description}{GDCQuery}(entity, field)

\method{field_description}{character}(entity, field)
}
\arguments{
\item{entity}{character(1) string ('cases','files','projects',
'annotations', etc.) or an subclass of \code{\link{GDCQuery}}.}

\item{field}{character(1), the name of the field that will be used to look
up the description.}
}
\value{
character(1) descriptive text or character(0) if no description
is available.
}
\description{
S3 Generic that returns the field description text, if available
}
\section{Methods (by class)}{
\itemize{
\item \code{field_description(GDCQuery)}: GDCQuery method

\item \code{field_description(character)}: character method

}}
\examples{
field_description('cases', 'annotations.category')
casesQuery = query('cases')
field_description(casesQuery, 'annotations.category')
field_description(cases(), 'annotations.category')

}
