% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut_type.R
\name{mut_type}
\alias{mut_type}
\title{Classification of DNA base mutations}
\usage{
mut_type(x, y)
}
\arguments{
\item{x, y}{Character strings denoting DNA bases}
}
\value{
A character string of same length of 'x' and 'y'.
}
\description{
Each DNA/RNA base can be classified into three main classes according to
three criteria (1): number of hydrogen bonds (strong-weak), chemical type
(purine-pyrimidine), and chemical groups (amino versus keto). Each criterion
produces a partition of the set of bases: 1. According to the number of
hydrogen bonds (on DNA/RNA double helix): strong \eqn{S=(C,G)} (three
hydrogen bonds) and weak \eqn{W=(A,U)} (two hydrogen bonds); 2. According to
the chemical type: purines \eqn{R=(A, G)} and pyrimidines \eqn{Y=(C,U)}. 3.
According to the presence of amino or keto groups on the base rings: amino
\eqn{M=(C,A)} and keto \eqn{K=(G,U)}. So, each mutational event can be
classified as according to the type of involved in it (2).
}
\examples{
## Mutation type 'R'
mut_type("A", "G")

## Mutation type 'M'
mut_type("A", "C")

## Mutation type 'W'
mut_type("A", "T")

## Mutation type 'S'
mut_type("G", "C")
}
\references{
\enumerate{
\item A. Cornish-Bowden, Nomenclature for incompletely specified bases
in nucleic acid sequences: recommendations 1984, Nucleic Acids
Res. 13 (1985) 3021-3030.
\item MA.A. Jimenez-Montano, C.R. de la Mora-Basanez, T. Poschel, The
hypercube structure of the genetic code explains conservative and
non-conservative aminoacid substitutions in vivo and in vitro,
Biosystems. 39 (1996) 117-125.
}
}
