% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_covid_aln.R
\docType{data}
\name{covid_aln}
\alias{covid_aln}
\title{Pairwise Sequence Alignment (MSA) of COVID-19 genomes.}
\format{
\code{\link[Biostrings]{DNAMultipleAlignment}} class object.
}
\usage{
data("covid_aln", package = "GenomAutomorphism")
}
\description{
This is a \code{\link[Biostrings]{DNAMultipleAlignment}} carrying the
pairwise sequence alignment of SARS coronavirus GZ02 (GenBank: AY390556.1:
265-13398_13398-21485) and Bat SARS-like coronavirus isolate bat-SL-CoVZC45
(GenBank: MG772933.1:265-1345513455-21542), complete genomes. The alignment
is available at GitHub:
\url{https://github.com/genomaths/seqalignments/tree/master/COVID-19}
}
\examples{
data("covid_aln", package = "GenomAutomorphism")
covid_aln

}
\seealso{
\link{brca1_aln}, \link{brca1_autm2}, \link{cyc_aln} and \link{covid_aln}.
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
\keyword{datasets}
