% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{CodonMatrix-class}
\alias{CodonMatrix-class}
\alias{CodonMatrix}
\title{A Convenient Class to Store a Codon Coordinate in given
Genetic Code cube.}
\usage{
CodonMatrix(object, group, cube, seq_alias = NULL)
}
\arguments{
\item{object}{A \code{\link[GenomicRanges]{GRanges-class}} object.}

\item{group}{The name of the base group, 'Z4' or 'Z5'.}

\item{cube}{The name of the genetic-code cube applied to get the
codon coordinates.}

\item{seq_alias}{The 'alias' given to the codon sequence.}
}
\value{
A 'CodonMatrix' class object
}
\description{
A CodonMatrix is the object created by function \link{codon_matrix}
}
\examples{
## CodonMatrix is generated by function 'codon_matrix' (inside a
## ListCodonMatrix-class object)
## Let's create DNAStringSet-class object
base <- DNAStringSet(x = c(S1 = 'ACGTGATCAAGT'))

x1 <- codon_matrix(base)
x1

## Extract the first element
x1[1]
x1$codon.1
x1[[1]]
}
\seealso{
\link{base_coord} and \link{codon_coord}.
}
\keyword{internal}
