% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/as.AutomorphismList.R
\docType{class}
\name{AutomorphismList-class}
\alias{AutomorphismList-class}
\alias{AutomorphismList}
\alias{names,AutomorphismList-method}
\alias{names<-,AutomorphismList-method}
\alias{'names<-'}
\alias{as.list,AutomorphismList-method}
\alias{show,AutomorphismList-method}
\alias{show-AutomorphismList}
\title{A class definition to store list of Automorphism class objects.}
\usage{
\S4method{names}{AutomorphismList}(x)

\S4method{names}{AutomorphismList}(x) <- value

\S4method{as.list}{AutomorphismList}(x)

\S4method{show}{AutomorphismList}(object)
}
\arguments{
\item{x}{An \code{\link{AutomorphismList-class}} object.}

\item{value}{A character vector naming the elements of the
\code{\link{AutomorphismList-class}} object 'x'.}

\item{object}{An object from \code{\link{AutomorphismList-class}}.}
}
\value{
An object from AutomorphismList-class
}
\description{
A class definition to store list of Automorphism class objects
derived from the pairwise automorphism estimation from pairwise
alignments. Objects from this class are created by function
\code{\link{automorphisms}} and \code{\link{as.AutomorphismList}}.
}
\section{AutomorphismList-class methods}{

\subsection{as.AutomorphismList(x):}{

\emph{\strong{as.AutomorphismList}} function transform a list of
\code{\link[GenomicRanges]{GRanges-class}}, a
\code{\link[GenomicRanges]{GRangesList-class}}, a list of
\code{\link[base]{data.frame}} or a
\code{\link[S4Vectors]{DataFrame-class}}
objects into a \emph{\strong{AutomorphismList-class}} object.
}

\subsection{unlist(x)}{

It transforms a AutomorphismList-class object into an Automorphism-class
object.
}

\subsection{as.list(x)}{

It transforms a list of Automorphism-class objects into an
AutomorphismList-class object.
}

\subsection{as(x, "GRangesList")}{

It transforms a \code{\link[GenomicRanges]{GRangesList}} of
\code{\link{Automorphism-class}} objects into an
'AutomorphismList-class' object.
}

\subsection{names(x)}{

To get the element's names from an 'AutomorphismList-class' object.
}

\subsection{names(x) <- value}{

To assign names to the element from an 'AutomorphismList-class'
object.
}
}

\examples{
## Load datasets
data("autm", "brca1_autm")

## Transforming a list of Automorphisms into an AutomorphismList object
lista <- list(human = brca1_autm[[1]], gorilla = brca1_autm[[2]])
as.AutomorphismList(lista)

## Alternatively we can set
aut <- as.list(brca1_autm[seq(2)])
class(aut)

## And reverse it
aut <- as.AutomorphismList(aut)
aut

## Let's get the element names from object 'aut'
names(aut)

## Let's assign new names
names(aut) <- c("human_1", "gorilla_1")
names(aut)

## Transforming a GRangesList of Automorphisms into an AutomorphismList
## object
lista <- as(lista, "GRangesList")
as.AutomorphismList(lista)

## Transform a AutomorphismList-class object into an Automorphism-class
## object 
unlist(brca1_autm[seq(2)])
## Load a DNA sequence alignment
data("brca1_autm", package = "GenomAutomorphism")
names(brca1_autm)
## Load a DNA sequence alignment
data("brca1_autm", package = "GenomAutomorphism")
x1 <- brca1_autm[seq(2)]
names(x1)

## Let's assign a new names
names(x1) <- c("human_1.human_2.0", "human_1.gorilla_0")
names(x1) 
## Load a DNA sequence alignment
data("brca1_autm", package = "GenomAutomorphism")

## The list of the first three elements
autm_list <- as.list(brca1_autm[seq(3)])
autm_list
}
\seealso{
\code{\link{Automorphism-class}} and
\code{\link{AutomorphismByCoefList-class}}.
}
\keyword{internal}
