## Copyright (C) 2021 Robersy Sanchez <https://genomaths.com/>
## Author: Robersy Sanchez This file is part of the R package
## 'GenomAutomorphism'.  'GenomAutomorphism' is a free
## software: you can redistribute it and/or modify it under the
## terms of the GNU General Public License as published by the Free
## Software Foundation, either version 3 of the License, or (at
## your option) any later version.  This program is distributed in
## the hope that it will be useful, but WITHOUT ANY WARRANTY;
## without even the implied warranty of MERCHANTABILITY or FITNESS
## FOR A PARTICULAR PURPOSE. See the GNU General Public License for
## more details.  You should have received a copy of the GNU
## General Public License along with this program; if not, see
## <http://www.gnu.org/licenses/>.

#' Automorphisms between DNA Sequences from Primate Cytochrome C Genes
#'
#' This is a \code{\link{AutomorphismList}} object carrying a list of pairwise
#' automorphisms between the DNA sequences from the MSA of
#' [Primate Somatic Cytochrome C](https://bit.ly/3kdEAzs) to be used in the
#' examples provided for the package functions. The automorphisms were
#' estimated from the \code{\link{cyc_aln}} MSA with function
#' \code{\link{autZ64}}.
#' @usage 
#' data("cyc_autm", package = "GenomAutomorphism")
#' 
#' @author Robersy Sanchez <https://genomaths.com>
#' 
#' @seealso  [brca1_autm], [brca1_autm2], [covid_autm], and [covid_aln].
#' 
#' @format \code{\link{AutomorphismList}} class object.
#' 
#' @examples
#' data("cyc_autm", package = "GenomAutomorphism")
#' cyc_autm
#' 
"cyc_autm"
