## Copyright (C) 2021 Robersy Sanchez <https://genomaths.com/>
## Author: Robersy Sanchez This file is part of the R package
## 'GenomAutomorphism'.  'GenomAutomorphism' is a free
## software: you can redistribute it and/or modify it under the
## terms of the GNU General Public License as published by the Free
## Software Foundation, either version 3 of the License, or (at
## your option) any later version.  This program is distributed in
## the hope that it will be useful, but WITHOUT ANY WARRANTY;
## without even the implied warranty of MERCHANTABILITY or FITNESS
## FOR A PARTICULAR PURPOSE. See the GNU General Public License for
## more details.  You should have received a copy of the GNU
## General Public License along with this program; if not, see
## <http://www.gnu.org/licenses/>.

#' Pairwise Sequence Alignment (MSA) of COVID-19 genomes.
#'
#' This is a \code{\link[Biostrings]{DNAMultipleAlignment}} carrying the
#' pairwise sequence alignment of SARS coronavirus GZ02 (GenBank: AY390556.1:
#' 265-13398_13398-21485) and Bat SARS-like coronavirus isolate bat-SL-CoVZC45
#' (GenBank: MG772933.1:265-1345513455-21542), complete genomes. The alignment
#' is available at GitHub:
#' <https://github.com/genomaths/seqalignments/tree/master/COVID-19>
#' @usage 
#' data("covid_aln", package = "GenomAutomorphism")
#'
#' @format \code{\link[Biostrings]{DNAMultipleAlignment}} class object.
#' @author Robersy Sanchez <https://genomaths.com>
#' @seealso  [brca1_aln], [brca1_autm2], [cyc_aln] and [covid_aln].
#' @examples
#' data("covid_aln", package = "GenomAutomorphism")
#' covid_aln
#' 
"covid_aln"
