#' @rdname GenomAutomorphism
#' @name GenomAutomorphism
#' @title GenomAutomorphism: An R package to compute the automorphisms between
#' DNA sequences represented as elements from an Abelian group.
#' @description This is a R package to compute the automorphisms between
#' pairwise aligned DNA sequences represented as elements from a Genomic
#' Abelian group as described in reference (1). In a general scenario, whole
#' chromosomes or genomic regions from a population (from any species or close
#' related species) can be algebraically represented as a direct sum of cyclic
#' groups or more specifically Abelian \eqn{p}-groups. Basically, we propose
#' the representation of multiple sequence alignments (MSA) of length \eqn{N}
#' as a finite Abelian group created by the direct sum of homocyclic Abelian
#' group of \emph{prime-power order}.
#' @keywords internal 
"_PACKAGE"
#' @references
#' \enumerate{
#' \item Robersy Sanchez, Jesus Barreto (2021) Genomic Abelian Finite
#' Groups. \url{https://doi.org/10.1101/2021.06.01.446543}.
#'
#' \item  Sanchez R, Morgado E, Grau R. Gene algebra from a genetic code
#' algebraic structure. J Math Biol. 2005 Oct;51(4):431-57. doi:
#' 10.1007/s00285-005-0332-8. Epub 2005 Jul 13. PMID: 16012800. (
#' \href{https://arxiv.org/pdf/q-bio/0412033.pdf}{PDF}.
#'
#' \item Sanchez R, Grau R, Morgado E. A novel Lie algebra of the genetic code
#' over the Galois field of four DNA bases. Math Biosci. 2006;202: 156-174.
#' doi:10.1016/j.mbs.2006.03.017
#'
#' \item Sanchez R, Grau R. An algebraic hypothesis about the primeval genetic
#' code architecture. Math Biosci. 2009/07/18. 2009;221: 60-76.
#' \url{https://doi.org/10.1016/j.mbs.2009.07.001}.
#'
#' \item 5. M. V Jose, E.R. Morgado, R. Sanchez, T. Govezensky, The 24 possible
#' algebraic representations of the standard genetic code in six or in three
#' dimensions, Adv. Stud. Biol. 4 (2012) 119-152.
#' \href{https://is.gd/na9eap}{PDF}.
#'
#' \item. R. Sanchez. Symmetric Group of the Genetic-Code Cubes. Effect of the
#' Genetic-Code Architecture on the Evolutionary Process MATCH Commun. Math.
#' Comput. Chem. 79 (2018) 527-560. \href{https://bit.ly/2Z9mjM7}{PDF}.
#' }
#'
NULL
