% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/happy_hour.R
\name{happy_hour}
\alias{happy_hour}
\title{Happy hour!}
\usage{
happy_hour(
  dds,
  res_de,
  res_enrich,
  annotation_obj,
  gtl = NULL,
  project_id,
  mygenesets,
  mygenes,
  mygroup = NULL,
  usage_mode = "batch_mode",
  input_rmd = NULL,
  output_file = "my_first_GeneTonic_happyhour.html",
  output_dir = tempdir(),
  output_format = NULL,
  force_overwrite = FALSE,
  knitr_show_progress = FALSE,
  ignore_pandoc = FALSE,
  open_after_creating = TRUE,
  ...
)
}
\arguments{
\item{dds}{A \code{DESeqDataSet} object, normally obtained after running your data
through the \code{DESeq2} framework.}

\item{res_de}{A \code{DESeqResults} object. As for the \code{dds} parameter, this is
also commonly used in the \code{DESeq2} framework.}

\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See \code{\link[=GeneTonic]{GeneTonic()}} for the formatting requirements.}

\item{annotation_obj}{A \code{data.frame} object with the feature annotation
information, with at least two columns, \code{gene_id} and \code{gene_name}. See
\code{\link[=GeneTonic]{GeneTonic()}} for the formatting requirements.}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}

\item{project_id}{A character string, which can be considered as an identifier
for the set/session, and will be e.g. used in the title of the report created
via \code{\link[=happy_hour]{happy_hour()}}}

\item{mygenesets}{A vector of character strings, containing the genesets to
focus on in the report - for each geneset, e.g. a signature heatmap can be
created.}

\item{mygenes}{A vector of character strings, containing the genes to focus on
in the report - for each gene, the plot of the expression values is included.}

\item{mygroup}{A character string, or a vector thereof. Contains the experimental
variables to be used to split into groups the expression data, and color
accordingly.}

\item{usage_mode}{A character string, which controls the behavior of the Rmd
document, based on whether the rendering is triggered while using the app
("shiny_mode"), or offline, in batch mode. Defaults to "batch_mode".}

\item{input_rmd}{Character string with the path to the RMarkdown (.Rmd) file
that will be used as the template for generating the report. Defaults to NULL,
which will then use the one provided with the \code{GeneTonic} package.}

\item{output_file}{Character string, specifying the file name of the output
report. The file name extension must be either \code{.html} or \code{.pdf}, and consistent
with the value of \code{output_format}.}

\item{output_dir}{Character, defining the path to the output directory where
the report will be generated. Defaults to the temp directory (\code{tempdir()}).}

\item{output_format}{The format of the output report. Either \code{html_document}
or \code{pdf_document}. The file name extension of \code{output_file} must be consistent
with this choice. Can also be left empty and determined accordingly.}

\item{force_overwrite}{Logical, whether to force overwrite an existing report
with the same name in the output directory. Defaults to FALSE.}

\item{knitr_show_progress}{Logical, whether to display the progress of \code{knitr}
while generating the report. Defaults to FALSE.}

\item{ignore_pandoc}{Logical, controlling how the report generation function
will behave if \code{pandoc} or \code{pandoc-citeproc} are missing.}

\item{open_after_creating}{Logical, whether to open the report in the default
browser after being generated. Defaults to TRUE.}

\item{...}{Other arguments that will be passed to \code{\link[rmarkdown:render]{rmarkdown::render()}}.}
}
\value{
Generates a fully fledged report in the \code{output_dir} directory, called
\code{output_file} and returns (invisibly) the name of the generated report.
}
\description{
Start the happy hour, creating a report containing a document full of goodies
derived from the provided objects.
}
\details{
When \code{happy_hour} is called, a RMarkdown template file will be copied
into the output directory, and \code{\link[rmarkdown:render]{rmarkdown::render()}} will be called to
generate the final report.

As a default template, \code{happy_hour} uses the one delivered together with the
\code{GeneTonic} package, which provides a comprehensive overview of what the user
can extract. Experienced users can take that as a starting point to further
edit and customize.

If there is already a .Rmd file with the same name in the output directory,
the function will raise an error and stop, to avoid overwriting the existing
file. The reason for this behaviour is that the copied template in the output
directory will be deleted once the report is generated.

Credits to the original implementation proposed by Charlotte Soneson,
upon which this function is \strong{heavily} inspired.
}
\examples{
library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)
\dontrun{
happy_hour(
  dds = dds_macrophage,
  res_de = res_de,
  res_enrich = res_enrich,
  annotation_obj = anno_df,
  project_id = "examplerun",
  mygroup = "condition",
  # mygroup = "line",   # alternatively
  mygenesets = res_enrich$gs_id[c(1:5, 11, 31)],
  mygenes = c(
    "ENSG00000125347",
    "ENSG00000172399",
    "ENSG00000137496"
  )
)
}
}
\seealso{
\code{\link[=GeneTonic]{GeneTonic()}}, \code{\link[=shake_topGOtableResult]{shake_topGOtableResult()}}, \code{\link[=shake_enrichResult]{shake_enrichResult()}}
}
