% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_summaries.R
\name{gs_summary_overview_pair}
\alias{gs_summary_overview_pair}
\title{Plots a summary of enrichment results}
\usage{
gs_summary_overview_pair(
  res_enrich,
  res_enrich2,
  n_gs = 20,
  p_value_column = "gs_pvalue",
  color_by = "z_score",
  alpha_set2 = 1
)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to check the
formatting requirements (a minimal set of columns should be present).}

\item{res_enrich2}{As \code{res_enrich}, the result of functional enrichment analysis,
in a scenario/contrast different than the first set.}

\item{n_gs}{Integer value, corresponding to the maximal number of gene sets to
be displayed}

\item{p_value_column}{Character string, specifying the column of \code{res_enrich}
where the p-value to be represented is specified. Defaults to \code{gs_pvalue}
(it could have other values, in case more than one p-value - or an adjusted
p-value - have been specified).}

\item{color_by}{Character, specifying the column of \code{res_enrich} to be used
for coloring the plotted gene sets. Defaults sensibly to \code{z_score}.}

\item{alpha_set2}{Numeric value, between 0 and 1, which specified the alpha
transparency used for plotting the points for gene set 2.}
}
\value{
A \code{ggplot} object
}
\description{
Plots a summary of enrichment results - for two sets of results
}
\examples{

library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)

res_enrich2 <- res_enrich[1:42, ]
set.seed(42)
shuffled_ones <- sample(seq_len(42)) # to generate permuted p-values
res_enrich2$gs_pvalue <- res_enrich2$gs_pvalue[shuffled_ones]
res_enrich2$z_score <- res_enrich2$z_score[shuffled_ones]
res_enrich2$aggr_score <- res_enrich2$aggr_score[shuffled_ones]
# ideally, I would also permute the z scores and aggregated scores
gs_summary_overview_pair(
  res_enrich = res_enrich,
  res_enrich2 = res_enrich2
)
}
\seealso{
\code{\link[=gs_summary_overview]{gs_summary_overview()}}, \code{\link[=gs_horizon]{gs_horizon()}}
}
