% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhance_table.R
\name{get_aggrscores}
\alias{get_aggrscores}
\title{Compute aggregated scores for gene sets}
\usage{
get_aggrscores(res_enrich, res_de, annotation_obj, gtl = NULL, aggrfun = mean)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to check the
formatting requirements (a minimal set of columns should be present).}

\item{res_de}{A \code{DESeqResults} object.}

\item{annotation_obj}{A \code{data.frame} object with the feature annotation
information, with at least two columns, \code{gene_id} and \code{gene_name}.}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}

\item{aggrfun}{Specifies the function to use for aggregating the scores for
each term. Common values could be \code{mean} or \code{median}.}
}
\value{
A \code{data.frame} with the same columns as provided in the input, with
additional information on the \code{z_score} and the \code{aggr_score} for each gene set.
This information is used by other functions such as \code{\link[=gs_volcano]{gs_volcano()}} or
\code{\link[=enrichment_map]{enrichment_map()}}
}
\description{
Computes for each gene set in the \code{res_enrich} object a Z score and an aggregated
score (using the log2FoldChange values, provided in the \code{res_de})
}
\examples{

library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)

res_enrich <- get_aggrscores(
  res_enrich,
  res_de,
  anno_df
)
}
\seealso{
\code{\link[=gs_volcano]{gs_volcano()}} and \code{\link[=enrichment_map]{enrichment_map()}} make efficient use of the computed
aggregated scores
}
