% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWhippetFiles.R
\name{readWhippetPSIfiles}
\alias{readWhippetPSIfiles}
\title{Read in a list of whippet .psi.gz files and format as a data.frame}
\usage{
readWhippetPSIfiles(files, attribute = "Total_Reads", maxNA = NA)
}
\arguments{
\item{files}{vector of *.psi.gz file names}

\item{attribute}{which attribute from the PSI files to use (Total_Reads, Psi, CI_width)}

\item{maxNA}{maximum number of NA values allowed before a site is removed}
}
\value{
data.frame with junction counts for all files
}
\description{
Read in a list of whippet .psi.gz files and format as a data.frame
}
\examples{
whippetFiles <- list.files(system.file("extdata","whippet/",
package = "GeneStructureTools"), full.names = TRUE)
psiFiles <- whippetFiles[grep(".psi", whippetFiles)]
whippetPSI <- readWhippetPSIfiles(psiFiles)
}
\seealso{
Other whippet data processing: \code{\link{coordinates}},
  \code{\link{diffSplicingResults}},
  \code{\link{filterWhippetEvents}},
  \code{\link{formatWhippetEvents}},
  \code{\link{junctions}}, \code{\link{readCounts}},
  \code{\link{readWhippetDIFFfiles}},
  \code{\link{readWhippetDataSet}},
  \code{\link{readWhippetJNCfiles}},
  \code{\link{whippetTranscriptChangeSummary}}
}
\author{
Beth Signal
}
