% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AltSplicingJunctionSupported.R
\name{findJunctionPairs}
\alias{findJunctionPairs}
\title{Find alternative junctions for Whippet alternative splicing events}
\usage{
findJunctionPairs(whippetDataSet, jncCoords, type = NA)
}
\arguments{
\item{whippetDataSet}{whippetDataSet generated from \code{readWhippetDataSet()}}

\item{jncCoords}{GRanges object with Whippet junctions. Generated by readWhippetJNCfiles()}

\item{type}{type of Whippet event (AA/AD/AF/AL).
Note only one event type should be processed at a time.}
}
\value{
GRanges object with alternative junctions.
Each event should have a set of X (for which the psi measurement is reported) junctions,
and alternative Y junctions.
}
\description{
Find junctions that pair with each end of an AA (alt. acceptor) or
AD (alt. donor) whippet range
Find junctions that pair with the upsteam/downstream exon of an
AF (alt. first exon) or an AL (alt. last exon)
}
\examples{
whippetFiles <- system.file("extdata","whippet/",
package = "GeneStructureTools")
wds <- readWhippetDataSet(whippetFiles)
wds <- filterWhippetEvents(wds)

gtf <- rtracklayer::import(system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools"))
exons <- gtf[gtf$type=="exon"]
transcripts <- gtf[gtf$type=="transcript"]
g <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10

wds.altAce <- filterWhippetEvents(wds, eventTypes="AA")
jncPairs.altAce <- findJunctionPairs(wds.altAce, type="AA")

wds.altDon <- filterWhippetEvents(wds, eventTypes="AD")
jncPairs.altDon <- findJunctionPairs(wds.altDon, type="AD")

wds.altFirst <- filterWhippetEvents(wds, eventTypes="AF", psiDelta=0.2)
jncPairs.altFirst <- findJunctionPairs(wds.altFirst, type="AF")

wds.altLast <- filterWhippetEvents(wds, eventTypes="AL", psiDelta=0.2)
jncPairs.altLast <- findJunctionPairs(wds.altLast, type="AL")
}
\seealso{
Other whippet splicing isoform creation: \code{\link{addIntronInTranscript}},
  \code{\link{findExonContainingTranscripts}},
  \code{\link{findIntronContainingTranscripts}},
  \code{\link{replaceJunction}},
  \code{\link{skipExonInTranscript}}
}
\author{
Beth Signal
}
