% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTranscripts.R
\name{attrChangeAltSpliced}
\alias{attrChangeAltSpliced}
\title{Evaluate the change in an attribute between a set of 'normal' transcripts and
'alternative' transcripts}
\usage{
attrChangeAltSpliced(orfsX, orfsY, attribute = "orf_length",
  compareBy = "gene", useMax = TRUE, compareUTR = FALSE)
}
\arguments{
\item{orfsX}{orf information for 'normal' transcripts. Generated by getOrfs()}

\item{orfsY}{orf information for 'alternative' transcripts. Generated by getOrfs()}

\item{attribute}{attribute to compare}

\item{compareBy}{compare by 'transcript' isoforms or by 'gene' groups}

\item{useMax}{use max as the summary function when multiple isoforms are aggregated?
If FALSE, will use min instead.}

\item{compareUTR}{compare the UTR lengths between transcripts?
Only runs if attribute = "orf_length"}
}
\value{
data.frame with attribute changes
}
\description{
Evaluate the change in an attribute between a set of 'normal' transcripts and
'alternative' transcripts
}
\examples{
whippetFiles <- system.file("extdata","whippet/",
package = "GeneStructureTools")
wds <- readWhippetDataSet(whippetFiles)
wds <- filterWhippetEvents(wds)

gtf <- rtracklayer::import(system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools"))
exons <- gtf[gtf$type=="exon"]
transcripts <- gtf[gtf$type=="transcript"]
g <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10

wds.exonSkip <- filterWhippetEvents(wds, eventTypes="CE",psiDelta = 0.2)
exons.exonSkip <- findExonContainingTranscripts(wds.exonSkip, exons,
variableWidth=0, findIntrons=FALSE, transcripts)
ExonSkippingTranscripts <- skipExonInTranscript(exons.exonSkip, exons, whippetDataSet=wds.exonSkip)

orfsSkipped <- getOrfs(ExonSkippingTranscripts[ExonSkippingTranscripts$set=="skipped_exon"],
BSgenome = g)
orfsIncluded <- getOrfs(ExonSkippingTranscripts[ExonSkippingTranscripts$set=="included_exon"],
BSgenome = g)
attrChangeAltSpliced(orfsSkipped, orfsIncluded,attribute = "orf_length")
}
\seealso{
Other transcript isoform comparisons: \code{\link{orfDiff}},
  \code{\link{transcriptChangeSummary}}
}
\author{
Beth Signal
}
