% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_and_modules.R
\name{plot_modules_merge}
\alias{plot_modules_merge}
\title{Modules merge plot}
\usage{
plot_modules_merge(
  modules_premerge,
  modules_merged,
  zoom = 1,
  vertex_size = 6,
  vertex_label_color = "gray20",
  vertex_label_family = "Helvetica",
  vertex_label_cex = 0.8,
  vertex_color = "lightskyblue",
  vertex_frame_color = "white",
  window_x_min = -1,
  window_x_max = 1,
  window_y_min = -1,
  window_y_max = 1,
  ...
)
}
\arguments{
\item{modules_premerge}{vector, id (whole number or string) of module before
merge associated to each gene.}

\item{modules_merged}{vector, id (whole number or string) of module after
merge associated to each gene.}

\item{zoom}{decimal, value to which the display will be increased/decreased.}

\item{vertex_size}{integer, size of the vertices.}

\item{vertex_label_color, vertex_color, vertex_frame_color}{string, name of the
color or hexadecimal code.}

\item{vertex_label_family}{string, font family name.}

\item{vertex_label_cex}{decimal, value for font size.}

\item{window_x_min}{decimal, value for the bottom limit of the window.}

\item{window_x_max}{decimal, value for the top limit of the window.}

\item{window_y_min}{decimal, value for the left limit of the window.}

\item{window_y_max}{decimal, value for the right limit of the window.}

\item{...}{additional arguments to be passed to igraph::plot.igraph().}
}
\value{
The layout of the plot
}
\description{
Plot a bipartite graph to see in which modules all modules have been merged
}
\details{
Both vectors must be in the same gene order before passing them to
the function. No check is applied on this.
}
\examples{
df <- kuehne_expr[1:24, 1:350]
net <- build_net(df, n_threads = 1)
detection <- detect_modules(df, net$network, detailled_result = TRUE)
plot_modules_merge(modules_premerge = detection$modules_premerge,
                   modules_merged = detection$modules)

}
