% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BICOSS.R
\name{BICOSS}
\alias{BICOSS}
\title{BICOSS for Gaussian Phenotypes}
\usage{
BICOSS(
  Y,
  SNPs,
  FDR_Nominal = 0.05,
  kinship = diag(nrow(SNPs)),
  maxiterations = 400,
  runs_til_stop = 40,
  P3D = TRUE
)
}
\arguments{
\item{Y}{The observed numeric phenotypes}

\item{SNPs}{The SNP matrix, where each column represents a single SNP encoded as the numeric coding 0, 1, 2. This is entered as a matrix object.}

\item{FDR_Nominal}{The nominal false discovery rate for which SNPs are selected from in the screening step.}

\item{kinship}{The observed kinship matrix, has to be a square positive semidefinite matrix. Defaulted as the identity matrix. The function used
to create the kinship matrix used in the BICOSS paper is A.mat() from package rrBLUP.}

\item{maxiterations}{The maximum iterations the genetic algorithm in the model selection step iterates for.
Defaulted at 400 which is the value used in the BICOSS paper simulation studies.}

\item{runs_til_stop}{The number of iterations at the same best model before the genetic algorithm in the model selection step converges.
Defaulted at 40 which is the value used in the BICOSS paper simulation studies.}

\item{P3D}{Population previous determined, if TRUE BICOSS uses approximated variance parameters estimated from the baseline model when conducting
both the screening and the model selection steps. Setting P3D = TRUE is significantly faster. If FALSE, uses exact estimates of the variance
parameters all models in both the screening and model selection step.}
}
\value{
The column indices of SNPs that were in the best model identified by BICOSS.
}
\description{
Performs BICOSS analysis as described in Williams, J., Ferreira, M.A.R. & Ji, T. BICOSS: Bayesian iterative conditional stochastic search for GWAS. BMC Bioinformatics 23, 475 (2022). https://doi.org/10.1186/s12859-022-05030-0.
}
\examples{
library(GWAS.BAYES)
BICOSS(Y = Y, SNPs = SNPs, kinship = kinship,
    FDR_Nominal = 0.05,P3D = TRUE,
    maxiterations = 400,runs_til_stop = 40)
}
