% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineOfftargets.R
\name{combineOfftargets}
\alias{combineOfftargets}
\title{Combine Offtargets}
\usage{
combineOfftargets(
  offtarget.folder,
  sample.name,
  remove.common.offtargets = FALSE,
  control.sample.name,
  offtarget.filename = "offTargetsInPeakRegions.xls",
  common.col = c("total.mismatch.bulge", "chromosome", "offTarget_Start",
    "offTarget_End", "offTargetStrand", "offTarget_sequence", "PAM.sequence",
    "guideAlignment2OffTarget", "mismatch.distance2PAM", "n.guide.mismatch",
    "n.PAM.mismatch", "n.DNA.bulge", "n.RNA.bulge", "pos.DNA.bulge", "DNA.bulge",
    "pos.RNA.bulge", "RNA.bulge", "gRNA.name", "gRNAPlusPAM", "predicted_cleavage_score",
    "inExon", "symbol", "entrez_id"),
  exclude.col = "",
  outputFileName,
  comparison.sample1,
  comparison.sample2,
  multiAdjMethod = "BH",
  comparison.score = c("peak_score", "n.distinct.UMIs"),
  overwrite = FALSE
)
}
\arguments{
\item{offtarget.folder}{offtarget summary output folders created in
GUIDEseqAnalysis function}

\item{sample.name}{Sample names to be used as part of the column names in
the final output file}

\item{remove.common.offtargets}{Default to FALSE If set to TRUE, off-targets
common to all samples will be removed.}

\item{control.sample.name}{The name of the control sample for filtering
off-targets present in the control sample}

\item{offtarget.filename}{Default to offTargetsInPeakRegions.xls, generated
in GUIDEseqAnalysis function}

\item{common.col}{common column names used for merge files. Default to
c("total.mismatch.bulge","chromosome", "offTarget_Start","offTarget_End",
"offTargetStrand","offTarget_sequence","PAM.sequence","guideAlignment2OffTarget",
"mismatch.distance2PAM","n.guide.mismatch","n.PAM.mismatch",
"n.DNA.bulge","n.RNA.bulge","pos.DNA.bulge","DNA.bulge","pos.RNA.bulge",
"RNA.bulge","gRNA.name","gRNAPlusPAM","predicted_cleavage_score",
"inExon","symbol","entrez_id")}

\item{exclude.col}{columns to be excluded before merging. Please check
offTargetsInPeakRegions.xls to choose the desired columns to exclude}

\item{outputFileName}{The merged offtarget file}

\item{comparison.sample1}{A vector of sample names to be used for comparison.
For example, comparison.sample1 = c("A", "B"),
comparison.sample2 = rep("Control", 2) indicates that you are
interested in comparing sample A vs Control and B vs Control
Please make sure the sample names specified in comparison.sample1 and
comparison.sample2 are in the sample name list specified in sample.name}

\item{comparison.sample2}{A vector of sample names to be used for comparison.
For example, comparison.sample1 = c("A", "B"),
comparison.sample2 = rep("Control", 2) indicates that you are
interested in comparing sample A vs Control and B vs Control}

\item{multiAdjMethod}{A vector of character strings containing the names of
the multiple testing procedures for which adjusted p-values are to be
computed. This vector should include any of the following: "none",
"Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BH", "BY", "ABH",
and "TSBH". Please type ?multtest::mt.rawp2adjp for details. Default to "BH"}

\item{comparison.score}{the score to be used for statistical analysis.
Two options are available: "peak_score" and "n.distinct.UMIs"
n.distinct.UMIs is the number of unique UMIs in the associated peak region
without considering the sequence coordinates while peak_score takes
into consideration of the sequence coordinates}

\item{overwrite}{Indicates whether to overwrite the existing file
specified by outputFileName, default to FALSE.}
}
\value{
a data frame containing all off-targets from all samples merged by
the columns specified in common.col. Sample specific columns have sample.name
concatenated to the original column name, e.g., peak_score becomes
sample1.peak_score.
}
\description{
Merge offtargets from different samples
}
\details{
Please note that by default, merged file will only contain peaks with
offtargets found in the genome in GUIDEseqAnalysis function.
}
\examples{

    offtarget.folder <- system.file("extdata",
        c("sample1-17", "sample2-18", "sample3-19"),
        package = "GUIDEseq")
    mergedOfftargets <-
       combineOfftargets(offtarget.folder = offtarget.folder,
       sample.name = c("Cas9Only", "WT-SpCas9", "SpCas9-MT3-ZFP"),
  comparison.sample1 = c("Cas9Only", "SpCas9-MT3-ZFP"),
  comparison.sample2 = rep("WT-SpCas9", 2),
       outputFileName = "TS2offtargets3Constructs.xlsx")

}
\author{
Lihua Julie Zhu
}
\keyword{misc}
