% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R
\name{nGenes}
\alias{nGenes}
\alias{genes}
\title{Get the number of genes for a \code{\linkS4class{GRN}} object.}
\usage{
nGenes(GRN, filter = TRUE)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{filter}{TRUE or FALSE. Default TRUE. Should genes marked as filtered be included in the count?}
}
\value{
Integer. Number of genes that are defined in the \code{\linkS4class{GRN}} object, either by excluding (filter = TRUE) or including (filter = FALSE) genes that are currently marked as \emph{filtered}.
}
\description{
Returns the number of genes (all or only non-filtered ones) from the provided RNA-seq data in the \code{\linkS4class{GRN}} object.
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
nGenes(GRN, filter = TRUE)
nGenes(GRN, filter = FALSE)
}
\seealso{
\code{\link{nTFs}}

\code{\link{nPeaks}}
}
