% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_module.R
\name{similarity_score}
\alias{similarity_score}
\title{Compute the similarity from a predefined condition group}
\usage{
similarity_score(gnet_result, group, ranked = FALSE)
}
\arguments{
\item{gnet_result}{Returned results from gnet().}

\item{group}{predefined condition grouping}

\item{ranked}{the grouping information is categorical(treatment/control) or ordinal(dosage, time points)?}
}
\value{
A list of similarity scores between a predefined condition grouping and the sample cluster of each module, and the p values for the similarity scores based on permutation.
}
\description{
Compute the similarity between a predefined condition grouping and the sample cluster of each module, which is defined
as the Adjusted Rand index between the two vectors, or the inverse of K-L divergence between the upper triangle matrix 
of the pairwise distance of predefined ranked condition grouping and the pairwise distance of sample cluster of each module.
}
\examples{
set.seed(1)
init_group_num = 8
init_method = 'kmeans'
exp_data <- matrix(rnorm(50*10),50,10)
reg_names <- paste0('TF',1:5)
rownames(exp_data) <- c(reg_names,paste0('gene',1:(nrow(exp_data)-length(reg_names))))
colnames(exp_data) <- paste0('condition_',1:ncol(exp_data))
se <- SummarizedExperiment::SummarizedExperiment(assays=list(counts=exp_data))
gnet_result <- gnet(se,reg_names,init_method,init_group_num)
s <- similarity_score(gnet_result,rep(1:5,each = 2))
}
