% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GDSFile-class.R
\docType{class}
\name{GDSFile-class}
\alias{GDSFile-class}
\alias{GDSFile}
\alias{GDSFile-constructor}
\alias{gdsfile,GDSFile-method}
\alias{GDSFile-method}
\alias{gdsfile<-}
\alias{gdsfile<-,GDSFile-method}
\alias{GDSFile,gdsfile-method}
\alias{$,GDSFile-method}
\alias{gdsnodes}
\alias{gdsnodes,ANY-method}
\alias{gdsnodes,GDSFile-method}
\title{GDSFile constructor and methods.}
\usage{
GDSFile(file, current_path = "")

\S4method{gdsfile}{GDSFile}(object)

gdsfile(object) <- value

\S4method{$}{GDSFile}(x, name)

\S4method{gdsnodes}{ANY}(x, node)
}
\arguments{
\item{file}{the GDS file path.}

\item{current_path}{the current path to the closest gds node.}

\item{object}{\code{GDSFile} object.}

\item{value}{the new gds file path}

\item{x}{a character string for the GDS file name or a \code{GDSFile} object.}

\item{name}{the name of gds node}

\item{node}{the node name of a gds file or \code{GDSFile} object.}
}
\value{
\code{gdsfile}: the file path of corresponding
    \code{GDSfile} object.

\code{$}: a \code{GDSFile} with updated \code{@current_path}, or
    \code{GDSArray} object if the \code{current_path} is a valid
    gds node.

\code{gdsnodes}: a character vector of all available gds
    nodes within the related GDS file and the specified node.
}
\description{
\code{GDSFile}: \code{GDSFile} is a light-weight class
    to represent a GDS file. It has the `$` completion method to
    complete any possible gds nodes. If the slot of `current_path`
    in `GDSFile` object represent a valid gds node, it will return
    the `GDSArray` of that node directly. Otherwise, it will return
    the `GDSFile` object with an updated `current_path`.

\code{GDSFile}: the \code{GDSFile} class constructor.

\code{gdsfile}: \code{filename} slot getter for
    \code{GDSFile} object.

\code{gdsfile<-}: \code{filename} slot setter for
    \code{GDSFile} object.

\code{gdsnodes}: to get the available gds nodes from a
    gds file name or a \code{GDSFile} object.
}
\examples{
fn <- gdsExampleFileName("seqgds")
gf <- GDSFile(fn)
gdsfile(gf)
fn <- gdsExampleFileName("seqgds")
gdsnodes(fn)
gdsnodes(fn, "annotation/info")
fn1 <- gdsExampleFileName("snpgds")
gdsnodes(fn1)
gdsnodes(fn1, "sample.annot")
gf <- GDSFile(fn)
gdsnodes(gf)
gdsnodes(gf, "genotype")
gdsfile(gf)
}
