% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdcFilterSamples.R
\name{gdcFilterSampleType}
\alias{gdcFilterSampleType}
\title{Filter out other type of samples}
\usage{
gdcFilterSampleType(metadata)
}
\arguments{
\item{metadata}{metadata parsed from \code{\link{gdcParseMetadata}}}
}
\value{
A filtered dataframe of metadata with \emph{Solid Tissue Normal} 
    and \emph{Primary Tumor} samples only
}
\description{
Filter out samples that are neither 
    \emph{Solid Tissue Normal} nor \emph{Primary Tumor}
}
\examples{
####### Parse metadata by project id and data type #######
metaMatrix <- gdcParseMetadata(project.id='TARGET-RT', data.type='RNAseq')
metaMatrix <- gdcFilterSampleType(metadata=metaMatrix)
}
\author{
Ruidong Li and Han Qu
}
