% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdcCorPlot.R
\name{gdcCorPlot}
\alias{gdcCorPlot}
\title{Correlation plot of two genes/miRNAs}
\usage{
gdcCorPlot(gene1, gene2, rna.expr, metadata)
}
\arguments{
\item{gene1}{an Ensembl gene id or miRBase v21 mature miRNA id}

\item{gene2}{an Ensembl gene id or miRBase v21 mature miRNA id}

\item{rna.expr}{\code{\link[limma]{voom}} transformed expression data}

\item{metadata}{metadata parsed from \code{\link{gdcParseMetadata}}}
}
\value{
A scatter plot with line of best fit
}
\description{
Scatter plot showing the expression correlation 
    between two genes/miRNAs
}
\examples{
genes <- c('ENSG00000000938','ENSG00000000971','ENSG00000001036',
        'ENSG00000001084','ENSG00000001167','ENSG00000001460')

samples <- c('TCGA-2F-A9KO-01', 'TCGA-2F-A9KP-01', 
            'TCGA-2F-A9KQ-01', 'TCGA-2F-A9KR-11', 
            'TCGA-2F-A9KT-11', 'TCGA-2F-A9KW-11')
             
metaMatrix <- data.frame(sample_type=rep(c('PrimaryTumor',
                        'SolidTissueNormal'),each=3),
                        sample=samples,
                        days_to_death=seq(100,600,100),
                        days_to_last_follow_up=rep(NA,6))

rnaExpr <- matrix(c(2.7,7.0,4.9,6.9,4.6,2.5,
                    0.5,2.5,5.7,6.5,4.9,3.8,
                    2.1,2.9,5.9,5.7,4.5,3.5,
                    2.7,5.9,4.5,5.8,5.2,3.0,
                    2.5,2.2,5.3,4.4,4.4,2.9,
                    2.4,3.8,6.2,3.8,3.8,4.2),6,6)
rownames(rnaExpr) <- genes
colnames(rnaExpr) <- samples
gdcCorPlot(gene1 = 'ENSG00000000938', 
        gene2    = 'ENSG00000001084',
        rna.expr = rnaExpr,
        metadata = metaMatrix)
}
\author{
Ruidong Li and Han Qu
}
