% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getRead}
\alias{getRead}
\alias{getRead,GbsrGenotypeData-method}
\title{Get read count data.}
\usage{
getRead(object, node = "raw", parents = FALSE, valid = TRUE, chr = NULL, ...)

\S4method{getRead}{GbsrGenotypeData}(object, node, parents, valid, chr)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{node}{Either of "raw" and "filt". See details.}

\item{parents}{A logical value or "only" whether to include data for
parents or not or to get data only for parents.}

\item{valid}{A logical value. See details.}

\item{chr}{An integer vector of indexes indicating
chromosomes to get read count data.}

\item{...}{Unused.}
}
\value{
A named list with two elements "ref" and "alt" storing
a matrix of reference allele read counts and a matrix of
alternative read counts for all markers in all samples.
}
\description{
Read counts for reference allele and alternative allele are retrieved
from the GDS file linked to the given \link{GbsrGenotypeData} object.
}
\details{
When \verb{node = "raw}, the raw read counts stored in the
"annotation/format/AD/data" node will be returned, while \verb{node = "filt} make
the function to return the filtered read counts stored in the
"annotation/format/FAD/data" that can be generated via the \code{\link[=setCallFilter]{setCallFilter()}}
function.
If \code{valid = TRUE}, read counts for only valid marker and valid samples will
be obtained.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

read <- getRead(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
\seealso{
\code{\link[=setCallFilter]{setCallFilter()}}
}
