% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getPosition}
\alias{getPosition}
\alias{getPosition,GbsrGenotypeData-method}
\title{Obtain marker positions}
\usage{
getPosition(object, valid = TRUE, chr = NULL, ...)

\S4method{getPosition}{GbsrGenotypeData}(object, valid, chr)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{valid}{A logical value. See details.}

\item{chr}{A integer or string to specify chromosome to get information.}

\item{...}{Unused.}
}
\value{
An integer vector indicating the physical positions of markers.
}
\description{
This function returns physical positions of markers.
}
\details{
If \code{valid = TRUE}, the positions of the markers which are labeled \code{TRUE} in
the "valid" column of the "marker" slot will be returned. If you need the
positions of over all markers, set \code{valid = FALSE}. \code{\link[=validMar]{validMar()}} tells you
which markers are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

getPosition(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
