% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getMarID}
\alias{getMarID}
\alias{getMarID,GbsrGenotypeData-method}
\title{Obtain the marker IDs}
\usage{
getMarID(object, valid = TRUE, chr = NULL, ...)

\S4method{getMarID}{GbsrGenotypeData}(object, valid, chr)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{valid}{A logical value. See details.}

\item{chr}{A index to specify chromosome to get information.}

\item{...}{Unused.}
}
\value{
A integer vector of marker IDs.
}
\description{
Obtain the marker IDs
}
\details{
If \code{valid = TRUE}, the IDs of markers which are labeled \code{TRUE} in the "valid"
column of the "marker" slot will be returned. If you need the number
of over all markers, set \code{valid = FALSE}. \code{\link[=validMar]{validMar()}} tells you
which markers are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

getMarID(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
