% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getMAC}
\alias{getMAC}
\alias{getMAC,GbsrGenotypeData-method}
\title{Obtain minor allele counts per SNP or per sample}
\usage{
getMAC(object, target = "marker", valid = TRUE, ...)

\S4method{getMAC}{GbsrGenotypeData}(object, target, valid)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{target}{Either of "marker" and "sample".}

\item{valid}{A logical value. See details.}

\item{...}{Unused.}
}
\value{
A numeric vector of the minor allele counts per marker.
}
\description{
Obtain minor allele counts per SNP or per sample
}
\details{
You need to execute \code{\link[=countGenotype]{countGenotype()}} to calculate sumaary statisticsto be
obtained via this function.
If \code{valid = TRUE}, the chromosome information of markers which are
labeled \code{TRUE} in the \link{sample} slot will be returned.
\code{\link[=validMar]{validMar()}} tells you which samples are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Summarize the genotype count information and store them in the
# [marker] and [sample] slots of the [GbsrGenotypeData] object.
gds <- countGenotype(gds)

getMAC(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
