% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getCountGenoHet}
\alias{getCountGenoHet}
\alias{getCountGenoHet,GbsrGenotypeData-method}
\title{Obtain total heterozygote counts per SNP or per sample}
\usage{
getCountGenoHet(object, target = "marker", valid = TRUE, prop = FALSE, ...)

\S4method{getCountGenoHet}{GbsrGenotypeData}(object, target, valid, prop)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{target}{Either of "marker" and "sample".}

\item{valid}{A logical value. See details.}

\item{prop}{A logical value whether to return values as proportions of
total heterozygote counts to total non missing genotype counts or not.}

\item{...}{Unused.}
}
\value{
A numeric vector of (proportion of) heterozugous
genotype calls per marker.
}
\description{
Obtain total heterozygote counts per SNP or per sample
}
\details{
You need to execute \code{\link[=countGenotype]{countGenotype()}} to calculate sumaary statisticsto be
obtained via this function.
If \code{valid = TRUE}, the chromosome information of markers which are
labeled \code{TRUE} in the \link{sample} slot will be returned.
\code{\link[=validMar]{validMar()}} tells you which samples are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Summarize the genotype count information and store them in the
# [marker] and [sample] slots of the [GbsrGenotypeData] object.
gds <- countGenotype(gds)

getCountGenoHet(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
