% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{gbsrGDS2CSV}
\alias{gbsrGDS2CSV}
\alias{gbsrGDS2CSV,GbsrGenotypeData-method}
\title{Write a CSV file based on data in a GDS file}
\usage{
gbsrGDS2CSV(
  object,
  out_fn,
  node = "raw",
  incl_parents = TRUE,
  bp2cm = NULL,
  format = "",
  read = FALSE,
  ...
)

\S4method{gbsrGDS2CSV}{GbsrGenotypeData}(object, out_fn, node, incl_parents, bp2cm, format, read)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{out_fn}{A string to specify the path to an output VCF file.}

\item{node}{Either one of "raw", "filt", "cor", "hap", "dosage to output raw
genotype data, filtered genotype data, corrected genotype data, estimated
haplotype data, and estimated allele dosage data, respectively.}

\item{incl_parents}{A logical value to specify whether parental
samples should be included in an output VCF file or not.}

\item{bp2cm}{A numeric value to convert positions in basepairs (bp) to
centiMorgan (cm). The specified here is used to multiply position values. The
default is NULL and then internally sets \code{bp2cm = 4e-06} when
\verb{format = "qtl}. If not \verb{format = "qtl}, 1 is set to \code{bp2cm} as default.}

\item{format}{A string to indicate the output format. See details.}

\item{read}{A logical value to indicate whether read counts should be output
with genotype data or not. See details.}

\item{...}{Unused.}
}
\value{
The path to the CSV file.
}
\description{
Write out a CSV file with raw, filtered, corrected genotype data or
estimated haplotype data
stored in a GDS file.
}
\details{
Create a CSV file at location specified by out_fn. The setting
\code{format = "qtl"} makes the function export the data in the r/qtl format
that can be loaded using read.cross as \code{format = "csvs"} with a phenotype
data. If you have executed \code{\link[=estGeno]{estGeno()}} and your population is a biparental
population, set 'node = "dosage"' to export a r/qtl format CSV in which
homozygoutes of the alleles of Parent 1 and 2, which have been specified by
\code{\link[=setParents]{setParents()}}, are represented by A and B, respectively. If 'node = "raw"',
'node = "fill"', and 'node = "cor"', A and B in the r/qtl format CSV indicate
homozygoutes of reference and alternative alleles shown in a given VCF file.
This means that if Parent 1 has the alternative allele homozygoute at
Marker 1 and Offspring 1 has the same genotype with Parent 1, the genotype of
Offspring 1 at Marker 1 will be B in the r/qtl format CSV. On the other hand,
if you set 'node = "dosage"', the genotype of Offspring 1 at Marker 1 will be
A in the r/qtl format CSV.
The output CSV file has the rows indicating chromosome ID and positions
of markers followed by the rows indicating genotype or haplotype data of
samples.
If \code{read = TRUE}, the output of each genotype call would be in
the form of \verb{GT:ADR,ADA} where GT, ADR, and ADA represent genotype,
referenece read count, and alternative read count, respectively.
If \code{format = "qtl"}, \code{read = TRUE} will be ignored.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Create a CSV file with data from the GDS file
#  connected to the [GbsrGenotypeData] oobject.
out_fn <- tempfile("sample_out", fileext = ".csv")
gbsrGDS2CSV(gds, out_fn)

# Close the connection to the GDS file.
closeGDS(gds)

}
